// Copyright 2014 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file is autogenerated by:
//     mojo/public/tools/bindings/mojom_bindings_generator.py
// For:
//     device/devices_app/usb/public/interfaces/device.mojom
//

package org.chromium.mojom.device.usb;

public final class ControlTransferParams extends org.chromium.mojo.bindings.Struct {

    private static final int STRUCT_SIZE = 24;
    private static final org.chromium.mojo.bindings.DataHeader[] VERSION_ARRAY = new org.chromium.mojo.bindings.DataHeader[] {new org.chromium.mojo.bindings.DataHeader(24, 0)};
    private static final org.chromium.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];

    public int type;
    public int recipient;
    public byte request;
    public short value;
    public short index;

    private ControlTransferParams(int version) {
        super(STRUCT_SIZE, version);
    }

    public ControlTransferParams() {
        this(0);
    }

    public static ControlTransferParams deserialize(org.chromium.mojo.bindings.Message message) {
        return decode(new org.chromium.mojo.bindings.Decoder(message));
    }

    @SuppressWarnings("unchecked")
    public static ControlTransferParams decode(org.chromium.mojo.bindings.Decoder decoder0) {
        if (decoder0 == null) {
            return null;
        }
        org.chromium.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
        ControlTransferParams result = new ControlTransferParams(mainDataHeader.elementsOrVersion);
        if (mainDataHeader.elementsOrVersion >= 0) {
            result.type = decoder0.readInt(8);
        }
        if (mainDataHeader.elementsOrVersion >= 0) {
            result.recipient = decoder0.readInt(12);
        }
        if (mainDataHeader.elementsOrVersion >= 0) {
            result.request = decoder0.readByte(16);
        }
        if (mainDataHeader.elementsOrVersion >= 0) {
            result.value = decoder0.readShort(18);
        }
        if (mainDataHeader.elementsOrVersion >= 0) {
            result.index = decoder0.readShort(20);
        }
        return result;
    }

    @SuppressWarnings("unchecked")
    @Override
    protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
        org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
        encoder0.encode(type, 8);
        encoder0.encode(recipient, 12);
        encoder0.encode(request, 16);
        encoder0.encode(value, 18);
        encoder0.encode(index, 20);
    }

    /**
     * @see Object#equals(Object)
     */
    @Override
    public boolean equals(Object object) {
        if (object == this)
            return true;
        if (object == null)
            return false;
        if (getClass() != object.getClass())
            return false;
        ControlTransferParams other = (ControlTransferParams) object;
        if (this.type != other.type)
            return false;
        if (this.recipient != other.recipient)
            return false;
        if (this.request != other.request)
            return false;
        if (this.value != other.value)
            return false;
        if (this.index != other.index)
            return false;
        return true;
    }

    /**
     * @see Object#hashCode()
     */
    @Override
    public int hashCode() {
        final int prime = 31;
        int result = prime + getClass().hashCode();
        result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(type);
        result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(recipient);
        result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(request);
        result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(value);
        result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(index);
        return result;
    }
}

